#version 330

in vec3 Position;
in vec3 Normal;

uniform vec3 CAM_EYE;
uniform vec3 CAM_POS;
uniform bool BLINK;

float rand(vec3 co){
    return fract(sin(dot(co.xyz ,vec3(12.9898,78.233, 44.1234))) * 43758.5453);
}

bool isTop() {
	float factor = dot(Normal, vec3(0.0, 1.0, 0.0));
	float factor2 = dot(Normal, vec3(0.0, -1.0, 0.0));
	if (factor > 0.01 || factor2 > 0.01) return true;
	return false;
}

void main() {
	float RND = rand(Position);
	float dx = sin(Position.x + RND);
	float dy = sin(Position.y + RND);
	float dz = sin(Position.z + RND);
	
	if (BLINK ) {
		float dtoc = dot(Position.xz, Position.xz);
		float added = cos(dtoc);
		dx += added;
		dy += added;
		dz += added;
		dx = min(dx, 1.0f);
		dy = min(dy, 1.0f);
		dz = min(dz, 1.0f);
	}
	gl_FragColor = vec4(dx, dy, dz, 1.0f);

}